	.INCLUDE	"global.inc"
	.IMPORT	RAYCAST
	.IMPORT	TEXPAGEUPDT
	.IMPORT	RENDERSTATUS
	.IMPORT	SFXPLAY, SFXUPDT
	.IMPORT	FPS, PREVBTTNS
	.IMPORT	OBJDBTYPE, OBJDBXPOS, OBJDBYPOS, OBJSTATE
	.IMPORT	SINL, SINH
	.EXPORT	PLAYER, MAPUPDT, ACTORS, OBJECTS
	.EXPORT	GCINIT, GCREAD
	.EXPORT	SCREENFILL
	
	.CODE
	
;**************************************
;*
;* PLAYER INPUT AND UPDATE VIEW
;*
;**************************************
;
; UPDATE PLAYER DIRECTION AND POSITION
;
PLAYER:	LDA	GCBTTNS
	AND	#GCBTTN2
	BEQ	MOVEROTXY
;
; LOOK = CONSTANT
; X,Y AXIS = MOVE RELATIVE X,Y
;
MOVERELXY:	LDX	#64
	LDA	GCXPOS
	SEC
	SBC	CNTRX
	CLC
	ADC	#$04
	CMP	#$80
	ROR
	CMP	#$80
	ROR
	CMP	#$80
	ROR
	CMP	#$80
	ROR
	BPL	HALFY
	EOR	#$FF
	CLC
	ADC	#$01
	LDX	#192
HALFY:	STA	DX
	LDY	#128
	LDA	GCYPOS
	SEC
	SBC	CNTRY
	CMP	#$80
	ROR
	CMP	#$80
	ROR
	CMP	#$80
	ROR
	CMP	#$80
	ROR
	BPL	QUADRANT
	EOR	#$FF
	CLC
	ADC	#$01
	LDY	#0
QUADRANT:	STA	DY
	CMP	DX
	BCS	MOVERELY
	STX	RAYA
	LDA	DX
	LDX	#$05
	BNE	CALCMVRATE
MOVERELY:	CMP	#$00
	BEQ	CHKFLIPVIEW
	STY	RAYA
	LDX	#$05
CALCMVRATE:	DEX
	BEQ	CALCMVANGLE
	LSR
	BNE	CALCMVRATE
CALCMVANGLE:	LDA	RAYA
	CLC
	ADC	PLAYERA
	TAY
	JMP	PLAYERMV
CHKFLIPVIEW:	LDA	GCBTTNS	;SPIN PLAYER 180 DEG
	CMP	#$03	;IF BOTH BUTTONS PRESSED
	BNE	NOFLIPVIEW	;AND STATIONARY
	LDA	PREVBTTNS
	CMP	#$03
	BEQ	NOFLIPVIEW
	LDA	PLAYERA
	CLC
	ADC	#$80
	STA	PLAYERA
NOFLIPVIEW:	RTS
;
; X AXIS = ROTATE LOOK
; Y AXIS = MOVE FORWARD/BACKWARD
;
MOVEROTXY:	LDX	#GCLIMITDLY
	LDA	GCXPOS
	CMP	#$38
	BCC	GCXMINLIMIT
	LDX	GCXLIMITCNT
	BNE	GCXRATELOW
	LDA	#$08
	JMP	GCXRATEHI
GCXMINLIMIT:	CMP	#$08
	BCS	GCXRATELOW
	LDX	GCXLIMITCNT
	BNE	GCXRATELOW
	LDA	#$F7
	JMP	GCXRATEHI
GCXRATELOW:	DEX
	STX	GCXLIMITCNT
	SEC
	SBC	CNTRX
	CMP	#$80
	ROR
	CMP	#$80
	ROR
GCXRATEHI:	CLC
	ADC	PLAYERA
	STA	PLAYERA
	LDX	STRUGGLE
	BEQ	MOVEGCY
	CMP	PREVPLAYERA
	BEQ	MOVEGCY
	DEX
	STX	STRUGGLE
MOVEGCY:	STA	PREVPLAYERA
	LDX	#$00	;INITIAL SPEED SHIFT
	LDA	CNTRY
	SEC
	SBC	GCYPOS
	BPL	FORWARD
	EOR	#$FF
	CMP	#$07
	BCS	BACKITUP
	RTS
BACKITUP:	INX
	INX
	CMP	#$0C
	BCS	BACKUP
	INX
BACKUP:	LDA	PLAYERA
	CLC
	ADC	#$80	;ROTATE 180DEG
	TAY
	JMP	PLAYERMV
FORWARD:	LDY	PLAYERA
	CMP	#$07
	BCS	MOVEITFORWRD
	RTS
MOVEITFORWRD:	CMP	#$18
	BCS	PLAYERMV
	INX
	CMP	#$0F
	BCS	PLAYERMV
	INX
PLAYERMV:	STY	RAYA
	LDY	STRUGGLE	;IF STRUGGLE, DON'T MOVE
	BEQ	CHKWALL
	DEY
	STY	STRUGGLE	;BROKE FREE, RUN!
	BEQ	CHKWALL
	RTS
CHKWALL:	TXA
	PHA
	JSR	RAYCAST	;LOOK FOR WALL IN THE WAY
	PLA
	TAX
	LDY	RAYA
CHKDIST:	LDA	SINL,Y
	STA	MOVEY
	LDA	SINH,Y
	STA	MOVEY+1
	TYA		; COS(A) = SIN(A + 90DEG)
	CLC
	ADC	#$40
	TAY
	LDA	SINL,Y
	STA	MOVEX
	LDA	SINH,Y
	STA	MOVEX+1
	LDA	#$01
	STA	MOVELEN+1
	LDA	#MINDIST+8
	STA	MOVELEN
	CPX	#$00
	BEQ	ADJHITWALL
ADJSPD:	LDA	MOVEY+1	;ROTATE W/ SIGN EXTEND
	CMP	#$80
	ROR
	STA	MOVEY+1
	ROR	MOVEY
	LDA	MOVEX+1
	CMP	#$80
	ROR
	STA	MOVEX+1
	ROR	MOVEX
	LSR	MOVELEN+1
	ROR	MOVELEN
	DEX
	BNE	ADJSPD
ADJHITWALL:	INX
	LDA	HITDIST
	SEC
	SBC	MOVELEN
	LDA	HITDIST+1
	SBC	MOVELEN+1
	BMI	ADJSPD
	LDA	MOVELEN
	ORA	MOVELEN+1
	BNE	OKMOVE
	RTS
OKMOVE:	LDA	MOVEY
	CLC
	ADC	PLAYERY
	STA	PLAYERY
	LDA	MOVEY+1
	ADC	PLAYERY+1
	STA	PLAYERY+1
	LDA	MOVEX
	CLC
	ADC	PLAYERX
	STA	PLAYERX
	LDA	MOVEX+1
	ADC	PLAYERX+1
	STA	PLAYERX+1
	LDA	MOVELEN	;MOVING TAKES ENERGY
	LSR	MOVELEN+1
	ROR
	LSR
	LSR
	LSR
	LSR
	STA	MOVELEN
	LDA	ENERGY
	SEC
	SBC	MOVELEN
	STA	ENERGY
	LDA	ENERGY+1
	SBC	MOVELEN+1
	STA	ENERGY+1
;
; PUSH PLAYER AWAY FROM WALLS
;
CHKWALLLT:	LDX	PLAYERX	
	LDY	PLAYERX+1
	CPX	#MINDIST
	BCS	CHKWALLRT
	LDA	(MAPROW),Y
	AND	#$0F
	BEQ	CHKWALLUP
	LDA	#MINDIST
	STA	PLAYERX
	BNE	CHKWALLUP
CHKWALLRT:	CPX	#255-MINDIST
	BCC	CHKWALLUP
	INY
	LDA	(MAPROW),Y
	DEY
	AND	#$0F
	BEQ	CHKWALLUP
	LDA	#255-MINDIST
	STA	PLAYERX
CHKWALLUP:	LDX	PLAYERY
	CPX	#MINDIST
	BCS	CHKWALLDN
	LDA	(MAPROW),Y
	AND	#$F0
	BEQ	CHKWALLDN
	LDA	#MINDIST
	STA	PLAYERY
CHKWALLDN:	CPX	#255-MINDIST
	BCC	CHKMAPUPDT
	LDA	MAPWDTH
	CLC
	ADC	MAPROW
	STA	MAPPTR
	LDA	#$00
	ADC	MAPROW+1
	STA	MAPPTR+1
	LDA	(MAPPTR),Y
	AND	#$F0
	BEQ	CHKMAPUPDT
	LDA	#255-MINDIST
	STA	PLAYERY
CHKMAPUPDT:	LDA	PLAYERY+1
	CMP	PREVPLAYERY
	STA	PREVPLAYERY
	BNE	MAPUPDT
PLAYERDONE:	RTS
;
; UPDATE MAP PTRS
;
MAPUPDT:	LDX	#$00
	STX	MAPROW+1
	LDX	MAPSHFT
	LDA	PLAYERY+1
MAPCALC:	ASL
	ROL	MAPROW+1
	DEX
	BNE	MAPCALC
	STA	MAPROW
	CLC		;UPDATE OBJECT MAP ROW
	ADC	LVLOBJBASE
	STA	OBJROW
	LDA	MAPROW+1
	ADC	LVLOBJBASE+1
	STA	OBJROW+1
	LDA	MAPROW	;UPDATE TEX PAGE MAP ROW
	CLC
	ADC	LVLTPGBASE
	STA	TPGROW
	LDA	MAPROW+1
	ADC	LVLTPGBASE+1
	STA	TPGROW+1
	LDA	MAPROW	;UPDATE WALL MAP ROW
	CLC
	ADC	LVLMAPBASE
	STA	MAPROW
	LDA	MAPROW+1
	ADC	LVLMAPBASE+1
	STA	MAPROW+1
	JMP	TEXPAGEUPDT
;
; CHECK FOR PLAYER/OBJECT HIT.
;
OBJECTS:	LDY	PLAYERX+1
	LDA	(OBJROW),Y
	BNE	CHKOBJ
	RTS
CHKOBJ:	BMI	POWERUP
	LDA	ENERGY
	SEC
	SBC	#$00
	STA	ENERGY
	LDA	ENERGY+1
	SBC	#$01
	STA	ENERGY+1
	LDX	STRUGGLE
	BEQ	STRUGGLESTART
	DEX
	STX	STRUGGLE
	RTS
STRUGGLESTART:	LDA	#STRUGGLECNT
	STA	STRUGGLE
	LDY	#SFXSTRUGGLE
	JSR	SFXPLAY
	LDA	#$11	;DRAW RED WHILE STRUGGLING
	JMP	SCREENFILL
POWERUP:	LDA	ENERGY+1
	CMP	#100-POWERUPCNT
	BCC	GRABIT
	RTS
GRABIT:	LDA	#$CC
	JSR	SCREENFILL
	LDY	PLAYERX+1	;REMOVE POWERUP FROM MAP
	LDA	#$00
	STA	(OBJROW),Y
	LDA	#POWERUPCNT
	CLC
	ADC	ENERGY+1
	STA	ENERGY+1
	LDY	#SFXPOWERUP
	JMP	SFXPLAY
;
; MOVE THE ACTORS AROUND.
;
ACTORS:	LDX	ODBCUR
ACTORSLP:	LDA	OBJDBTYPE,X
	BNE	CHKACTOR
	JMP	NEXTACTOR
CHKACTOR:	BPL	ISACTOR
	JMP	NEXTACTOR
ISACTOR:	STA	TMPA
	LDY	#$00
	STY	MAPOFS+1
	LDY	MAPSHFT
	LDA	OBJDBYPOS,X	;ACTOR Y COORD
ACTORCALC:	ASL
	ROL	MAPOFS+1
	DEY
	BNE	ACTORCALC
	STA	MAPOFS
	LDA	OBJSTATE,X
	BEQ	LOOKFORPLAYER
	JMP	CHASEPLAYER
LOOKFORPLAYER:	LDA	MAPOFS
	CLC
	ADC	LVLMAPBASE
	STA	MAPPTR
	LDA	MAPOFS+1
	ADC	LVLMAPBASE+1
	STA	MAPPTR+1
	LDA	PLAYERX+1	;CHECK LINE OF SITE
	SEC		;FROM ACTOR TO PLAYER
	SBC	OBJDBXPOS,X
	STA	DX
	BPL	LOOKDY
	EOR	#$FF
	CLC
	ADC	#$01
LOOKDY:	STA	DX+1	;ABS DX
	LDA	PLAYERY+1
	SEC
	SBC	OBJDBYPOS,X
	STA	DY
	BPL	LOOKMAJOR
	EOR	#$FF
	CLC
	ADC	#$01
LOOKMAJOR:	STA	DY+1	;ABS DY
	CMP	DX+1
	BCC	LOOKXDIST
	JMP	LOOKYDIST
;
; CHECK X DIST.
;
LOOKXDIST:	LDA	DX+1
	CMP	#MINACTORMOVEDIST
	BCC	LOOKX	;TOO FAR AWAY
	JMP	NEXTACTOR
LOOKX:	LDA	DY+1
	ASL
	STA	INCMAJOR	;2*DY
	SEC
	SBC	DX+1
	STA	DERR
	LDA	DX+1
	ASL
	STA	INCMINOR	;2*DX
	LDA	DX
	BMI	LOOKXM
;
; LOOK X+
;
LOOKXP:	LDA	OBJDBXPOS,X
	TAY
LOOPXP:	INY
	LDA	(MAPPTR),Y
	AND	#$0F
	BEQ	LOOKCHKXPM
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKCHKXPM:	LDA	DERR
	BMI	LOOKINCXP
	BEQ	LOOKINCXP
	SEC		;MOVE MINOR DIRECTION
	SBC	INCMINOR
	STA	DERR
	LDA	DY
	BMI	LOOKXPYM
	LDA	MAPPTR	;LOOK Y+
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
	LDA	(MAPPTR),Y
	AND	#$F0
	BEQ	LOOKINCXPYP
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKXPYM:	LDA	(MAPPTR),Y	;LOOK Y-
	AND	#$F0
	BEQ	LOOKINCXPYM
	JMP	NEXTACTOR	;PLAYER NOT VISBLE
LOOKINCXPYM:	LDA	MAPPTR
	SEC
	SBC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	SBC	#$00
	STA	MAPPTR+1
LOOKINCXPYP:	LDA	DERR
LOOKINCXP:	CLC
	ADC	INCMAJOR
	STA	DERR
	DEC	DX+1
	BNE	LOOPXP
	JMP	CHASEPLAYER	;PLAYER VISIBLE
;
; LOOK X-
;
LOOKXM:	LDA	OBJDBXPOS,X
	TAY
LOOPXM:	LDA	(MAPPTR),Y
	AND	#$0F
	BEQ	LOOKCHKXMM
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKCHKXMM:	LDA	DERR
	BMI	LOOKINCXM
	BEQ	LOOKINCXM
	SEC		;MOVE MINOR DIRECTION
	SBC	INCMINOR
	STA	DERR
	LDA	DY
	BMI	LOOKXMYM
	LDA	MAPPTR	;LOOK Y+
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
	LDA	(MAPPTR),Y
	AND	#$F0
	BEQ	LOOKINCXMYP
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKXMYM:	LDA	(MAPPTR),Y	;LOOK Y-
	AND	#$F0
	BEQ	LOOKINCXMYM
	JMP	NEXTACTOR	;PLAYER NOT VISBLE
LOOKINCXMYM:	LDA	MAPPTR
	SEC
	SBC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	SBC	#$00
	STA	MAPPTR+1
LOOKINCXMYP:	LDA	DERR
LOOKINCXM:	CLC
	ADC	INCMAJOR
	STA	DERR
	DEY
	DEC	DX+1
	BNE	LOOPXM
	JMP	CHASEPLAYER	;PLAYER VISIBLE
;
; CHECK Y DIST.
;
LOOKYDIST:	LDA	DY+1
	BEQ	PLAYERONTOP	;PLAYER ON TOP OF ACTOR
	CMP	#MINACTORMOVEDIST
	BCC	LOOKY	;TOO FAR AWAY
PLAYERONTOP:	JMP	NEXTACTOR
LOOKY:	LDA	DX+1
	ASL
	STA	INCMAJOR	;2*DX
	SEC
	SBC	DY+1
	STA	DERR
	LDA	DY+1
	ASL
	STA	INCMINOR	;2*DY	
	LDA	DY
	BMI	LOOKYM
;
; LOOK Y+
;
LOOKYP:	LDA	OBJDBXPOS,X
	TAY
	LDA	MAPPTR
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
LOOPYP:	LDA	(MAPPTR),Y
	AND	#$F0
	BEQ	LOOKCHKYPM
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKCHKYPM:	LDA	DERR
	BMI	LOOKINCYP
	BEQ	LOOKINCYP
	SEC		;MOVE MINOR DIRECTION
	SBC	INCMINOR
	STA	DERR
	LDA	DX
	BMI	LOOKYPXM
	INY		;LOOK X+
	LDA	(MAPPTR),Y
	AND	#$0F
	BEQ	LOOKINCYPM
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKYPXM:	LDA	(MAPPTR),Y	;LOOK X-
	DEY
	AND	#$0F
	BEQ	LOOKINCYPM
	JMP	NEXTACTOR	;PLAYER NOT VISBLE
LOOKINCYPM:	LDA	DERR
LOOKINCYP:	CLC
	ADC	INCMAJOR
	STA	DERR
	LDA	MAPPTR
	CLC
	ADC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	ADC	#$00
	STA	MAPPTR+1
	DEC	DY+1
	BNE	LOOPYP
	JMP	CHASEPLAYER	;PLAYER VISIBLE
;
; LOOK Y-
;
LOOKYM:	LDA	OBJDBXPOS,X
	TAY
LOOPYM:	LDA	(MAPPTR),Y
	AND	#$F0
	BEQ	LOOKCHKYMM
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKCHKYMM:	LDA	DERR
	BMI	LOOKINCYM
	BEQ	LOOKINCYM
	SEC		;MOVE MINOR DIRECTION
	SBC	INCMINOR
	STA	DERR
	LDA	DX
	BMI	LOOKYMXM
	INY		;LOOK X+
	LDA	(MAPPTR),Y
	AND	#$0F
	BEQ	LOOKINCYMM
	JMP	NEXTACTOR	;PLAYER NOT VISIBLE
LOOKYMXM:	LDA	(MAPPTR),Y	;LOOK X-
	DEY
	AND	#$0F
	BEQ	LOOKINCYMM
	JMP	NEXTACTOR	;PLAYER NOT VISBLE
LOOKINCYMM:	LDA	DERR
LOOKINCYM:	CLC
	ADC	INCMAJOR
	STA	DERR
	LDA	MAPPTR
	SEC
	SBC	MAPWDTH
	STA	MAPPTR
	LDA	MAPPTR+1
	SBC	#$00
	STA	MAPPTR+1
	DEC	DY+1
	BNE	LOOPYM
;	JMP	CHASEPLAYER	;PLAYER VISIBLE
CHASEPLAYER:	LDA	STATELOOKING
	STA	OBJSTATE,X
	LDA	MAPOFS
	CLC		;ACTOR OBJECT MAP PTR
	ADC	LVLOBJBASE
	STA	OBJPTR
	LDA	MAPOFS+1
	ADC	LVLOBJBASE+1
	STA	OBJPTR+1
	LDA	MAPOFS	;ACTOR WALL MAP PTR
	CLC
	ADC	LVLMAPBASE
	STA	MAPPTR
	LDA	MAPOFS+1
	ADC	LVLMAPBASE+1
	STA	MAPPTR+1
	LDA	OBJDBXPOS,X	;CHECK XCOORD DISTANCE
	SEC
	SBC	PLAYERX+1
	BEQ	ACTORMVY
	BCC	ACTORMVXP
	CMP	#MINACTORMOVEDIST;TOO FAR AWAY
	BCS	ACTORMVY
	LDA	OBJDBXPOS,X
	TAY
	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	ACTORMVY	;WALL IN THE WAY
	DEY
	LDA	(OBJPTR),Y
	BNE	ACTORMVY	;ANOTHER OBJECT IN THE WAY
	LDA	TMPA	;RESTORE OBJECT TYPE
	STA	(OBJPTR),Y
	INY
	LDA	#$00
	STA	(OBJPTR),Y
	DEY
	TYA
	STA	OBJDBXPOS,X	;SAVE NEW XPOS
	LDA	STATECHASING
	STA	OBJSTATE,X
	JMP	ACTORMVY
ACTORMVXP:	EOR	#$FF
	CMP	#MINACTORMOVEDIST-1;TOO FAR AWAY
	BCS	ACTORMVY
	LDA	OBJDBXPOS,X
	TAY
	INY
	LDA	(MAPPTR),Y
	AND	#$0F
	BNE	ACTORMVY	;WALL IN THE WAY
	LDA	(OBJPTR),Y
	BNE	ACTORMVY	;ANOTHER OBJECT IN THE WAY
	LDA	TMPA	;RESTORE OBJECT TYPE
	STA	(OBJPTR),Y
	DEY
	LDA	#$00
	STA	(OBJPTR),Y
	INY
	TYA
	STA	OBJDBXPOS,X	;SAVE NEW XPOS
	LDA	STATECHASING
	STA	OBJSTATE,X
ACTORMVY:	LDA	OBJDBYPOS,X	;CHECK YCOORD DISTANCE
	SEC
	SBC	PLAYERY+1
	BEQ	NEXTACTOR
	BCC	ACTORMVYP
	CMP	#MINACTORMOVEDIST;TOO FAR AWAY
	BCS	NEXTACTOR
	LDA	OBJDBXPOS,X
	TAY
	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	NEXTACTOR	;WALL IN THE WAY
	LDA	OBJPTR
	SEC
	SBC	MAPWDTH
	STA	OBJPTR
	LDA	OBJPTR+1
	SBC	#$00
	STA	OBJPTR+1
	LDA	(OBJPTR),Y
	BNE	NEXTACTOR	;ANOTHER OBJECT IN THE WAY
	LDA	TMPA	;RESTORE OBJECT TYPE
	STA	(OBJPTR),Y
	TYA
	CLC
	ADC	MAPWDTH
	TAY
	LDA	#$00
	STA	(OBJPTR),Y
	LDA	OBJDBYPOS,X
	SEC
	SBC	#$01
	STA	OBJDBYPOS,X	;SAVE NEW YPOS
	LDA	STATECHASING
	STA	OBJSTATE,X
	JMP	NEXTACTOR
ACTORMVYP:	EOR	#$FF
	CMP	#MINACTORMOVEDIST-1;TOO FAR AWAY
	BCS	NEXTACTOR
	LDA	OBJDBXPOS,X
	ADC	MAPWDTH
	TAY
	LDA	(MAPPTR),Y
	AND	#$F0
	BNE	NEXTACTOR	;WALL IN THE WAY
	LDA	(OBJPTR),Y
	BNE	NEXTACTOR	;ANOTHER OBJECT IN THE WAY
	LDA	TMPA	;RESTORE OBJECT TYPE
	STA	(OBJPTR),Y
	LDA	OBJDBYPOS,X
	CLC
	ADC	#$01
	STA	OBJDBYPOS,X	;SAVE NEW YPOS
	LDA	OBJDBXPOS,X
	TAY
	LDA	#$00
	STA	(OBJPTR),Y
	LDA	STATECHASING
	STA	OBJSTATE,X
NEXTACTOR:	TXA
	CLC
	ADC	#ACTORMVCNT
	TAX
	CMP	#MAXOBJECTS
	BCS	ACTORSDONE
	JMP	ACTORSLP
ACTORSDONE:	LDX	ODBCUR
	INX
	CPX	#ACTORMVCNT
	BCC	NEXTACTORFRAME
	LDX	#$00
NEXTACTORFRAME:	STX	ODBCUR
	RTS
;
; FILL SCREEN WITH A SOLID COLOR.
;
SCREENFILL:	LDX	#19
	LDY	#20
	STA	TMPA
FILLCOLS:	STA	$400,X
	STA	$400,Y
	STA	$800,X
	STA	$800,Y
	STA	$480,X
	STA	$480,Y
	STA	$880,X
	STA	$880,Y
	STA	$500,X
	STA	$500,Y
	STA	$900,X
	STA	$900,Y
	STA	$580,X
	STA	$580,Y
	STA	$980,X
	STA	$980,Y
	STA	$600,X
	STA	$600,Y
	STA	$A00,X
	STA	$A00,Y
	STA	$680,X
	STA	$680,Y
	STA	$A80,X
	STA	$A80,Y
	STA	$700,X
	STA	$700,Y
	STA	$B00,X
	STA	$B00,Y
	STA	$780,X
	STA	$780,Y
	STA	$B80,X
	STA	$B80,Y
	STA	$428,X
	STA	$428,Y
	STA	$828,X
	STA	$828,Y
	STA	$4A8,X
	STA	$4A8,Y
	STA	$8A8,X
	STA	$8A8,Y
	STA	$528,X
	STA	$528,Y
	STA	$928,X
	STA	$928,Y
	STA	$5A8,X
	STA	$5A8,Y
	STA	$9A8,X
	STA	$9A8,Y
	STA	$628,X
	STA	$628,Y
	STA	$A28,X
	STA	$A28,Y
	STA	$6A8,X
	STA	$6A8,Y
	STA	$AA8,X
	STA	$AA8,Y
	STA	$728,X
	STA	$728,Y
	STA	$B28,X
	STA	$B28,Y
	STA	$7A8,X
	STA	$7A8,Y
	STA	$BA8,X
	STA	$BA8,Y
	STA	$450,X
	STA	$450,Y
	STA	$850,X
	STA	$850,Y
	STA	$4D0,X
	STA	$4D0,Y
	STA	$8D0,X
	STA	$8D0,Y
	STA	$550,X
	STA	$550,Y
	STA	$950,X
	STA	$950,Y
	STA	$5D0,X
	STA	$5D0,Y
	STA	$9D0,X
	STA	$9D0,Y
	LDA	RENDERSTATUS
	BNE	FILLNEXTCOL
	LDA	TMPA
	STA	$650,X
	STA	$650,Y
	STA	$A50,X
	STA	$A50,Y
	STA	$6D0,X
	STA	$6D0,Y
	STA	$AD0,X
	STA	$AD0,Y
	STA	$750,X
	STA	$750,Y
	STA	$B50,X
	STA	$B50,Y
	STA	$7D0,X
	STA	$7D0,Y
	STA	$BD0,X
	STA	$BD0,Y
FILLNEXTCOL:	LDA	TMPA
	CPX	VIEWCOLLEFT
	BEQ	FILLDONE
	INY
	DEX
	JMP	FILLCOLS
FILLDONE:	RTS
;
; INIT GC CENTER VALUES
;
GCINIT:	JSR	GCREAD
	LDA	GCXPOS
	SEC
	SBC	#$02
	STA	CNTRX
	LDA	GCYPOS
	SEC
	SBC	#$03
	STA	CNTRY
	RTS
;
; READ BOTH GAME CONTROLLERS IN PARALLEL
; 
GCREAD:	PHP
	SEI		;TURN INTS OFF
	LDA	#$00
	STA	GCXPOS
	STA	GCYPOS
	LDA	#64
	STA	RDCNT
	LDX	TONE
	BIT	GCSTROBE
GCLOOP:	LDY	GC1
	LDA	GC0
	ASL
	LDA	GCXPOS
	ADC	#$00
	STA	GCXPOS
	TYA
	ASL
	LDA	GCYPOS
	ADC	#$00
	STA	GCYPOS
	DEX
	BNE	GCNXT
	LDX	TONE
	BIT	SPEAKER
	DEC	RDCNT
	BNE	GCLOOP
	BEQ	GCRDPB
GCNXT:	NOP		; TIMING
	NOP
	NOP
	DEC	RDCNT
	BNE	GCLOOP
GCRDPB:	LDA	GCPB2
	ASL
	LDA	GCPB1
	ROL
	ROL
	AND	#$03
	STA	GCBTTNS
	PLP
	RTS

	.DATA

PREVPLAYERA:	.BYTE	$00
PREVPLAYERY:	.BYTE	$FF
STRUGGLE:	.BYTE	$00
GCXLIMITCNT:	.BYTE	GCLIMITDLY
